﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Attributes : RPGByteData
    {
        List<Attribute> attributes;
        
        public Attributes(FileStream f)
        {
            load(f);
        }
        public Attributes()
        {
        }
        
        override public void load(FileStream f)
        {
            attributes = M.readDatabaseList<Attribute>(f, "Attributes", "Attribute", ref M.attributeNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Attribute>(attributes);
        }
    }
    
    class Attribute : RPGDatabaseEntry
    {
        int id = 0;
        string attributeName = ""; // 01
        int physicalOrMagical = 0; // 02
        int rateA = 300; // 0b
        int rateB = 200; // 0c
        int rateC = 100; // 0d
        int rateD = 50; // 0e
        int rateE = 0; // 0f
        
        static string myClass = "Attribute";
        Chunks chunks;
        
        public Attribute(FileStream f)
        {
            load(f);
        }
        public Attribute()
        {
        }
        
        public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                attributeName = M.readStringDataName(f, id, ref M.attributeNames, M.S_TOTRANSLATE);
            
            if (chunks.next(0x02))
                physicalOrMagical = M.readLengthMultibyte(f);
            
            if (chunks.next(0x0b))
                rateA = M.readLengthMultibyte(f);
            if (chunks.next(0x0c))
                rateB = M.readLengthMultibyte(f);
            if (chunks.next(0x0d))
                rateC = M.readLengthMultibyte(f);
            if (chunks.next(0x0e))
                rateD = M.readLengthMultibyte(f);
            if (chunks.next(0x0f))
                rateE = M.readLengthMultibyte(f);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeString(attributeName, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x02))
                M.writeLengthMultibyte(physicalOrMagical);
            
            if (chunks.wasNext(0x0b))
                M.writeLengthMultibyte(rateA);
            if (chunks.wasNext(0x0c))
                M.writeLengthMultibyte(rateB);
            if (chunks.wasNext(0x0d))
                M.writeLengthMultibyte(rateC);
            if (chunks.wasNext(0x0e))
                M.writeLengthMultibyte(rateD);
            if (chunks.wasNext(0x0f))
                M.writeLengthMultibyte(rateE);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (attributeName != "" // 01
             || physicalOrMagical != 0 // 02
             || rateA != 300 // 0b
             || rateB != 200 // 0c
             || rateC != 100 // 0d
             || rateD != 50 // 0e
             || rateE != 0) // 0f
                return false;
            
            return true;
        }
    }
}
